/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.provider.rs6k.AsynchEventManager;
import com.ibm.hsc.cim.provider.rs6k.CimomWrapper;
import com.ibm.hsc.cim.provider.rs6k.HscCimObjUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.cim.provider.rs6k.indication.server.HSCEventQueue;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.HscProviderSocket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMClass;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMInstance;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMOMHandle;

public class SystemProfUpdater {
    private CIMOMHandle cimHandle = null;
    private CIMObjectPath sysProfObjPath;
    private CIMInstance sysProfInst;
    private String cecName;
    private String sysProfId;
    private HSCEventQueue eventQueue;

    public SystemProfUpdater(CIMOMHandle cIMOMHandle, CIMObjectPath cIMObjectPath, CIMInstance cIMInstance, HSCEventQueue hSCEventQueue) {
        this.cimHandle = cIMOMHandle;
        this.sysProfObjPath = cIMObjectPath;
        this.sysProfInst = cIMInstance;
        try {
            this.cecName = (String)cIMInstance.getProperty("ComputerSystemName").getValue().getValue();
            this.sysProfId = (String)cIMInstance.getProperty("Name").getValue().getValue();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.eventQueue = hSCEventQueue;
    }

    public void update(HscProviderSocket hscProviderSocket) throws CIMException {
        HscProviderSocket hscProviderSocket2 = hscProviderSocket;
        System.out.println("++++++++ cecName: " + this.cecName);
        System.out.println("++++++++ sysProfId: " + this.sysProfId);
        Vector vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(this.cecName)).getSysProfile(this.sysProfId, hscProviderSocket);
        if (vector == null || vector.size() == 0) {
            System.out.println("++++++++ sysProfId: " + this.sysProfId + " not in NVRAM!");
            CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem", "root/ibmhscV3_2");
            cIMObjectPath.addKey("CreationClassName", new CIMValue((Object)"IBMHSC_ComputerSystem"));
            cIMObjectPath.addKey("Name", new CIMValue((Object)this.cecName));
            HscCimObjUtils.deleteSystemProfile(this.eventQueue, this.cimHandle, this.sysProfInst, this.sysProfObjPath, cIMObjectPath);
            System.out.println("++++++++ sysProfId: " + this.sysProfId + " deleted!");
            return;
        }
        boolean bl = false;
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(1);
        String string = (String)cIMProperty.getValue().getValue();
        string = string.trim();
        System.out.println("++++++++ user defined name: " + string);
        CIMInstance cIMInstance = CimomWrapper.getInstance(this.cimHandle, this.sysProfObjPath, this.cimHandle.getClass(this.sysProfObjPath, false), false);
        CIMInstance cIMInstance2 = cIMInstance.filterProperties(null, true, true);
        if (CimomWrapper.setPropertyString(cIMInstance2, "UserDefinedName", string)) {
            System.out.println("+++++++++ UserDefinedName has been changed!");
            bl = true;
        }
        if (bl) {
            CimomWrapper.setInstance(this.cimHandle, this.sysProfObjPath, cIMInstance2);
            if (this.eventQueue != null) {
                this.eventQueue.add(4, cIMInstance2, cIMInstance);
            } else {
                try {
                    AsynchEventManager.sendIndication(4, cIMInstance2, cIMInstance);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    HSCLogUtils.serverLog(throwable, HSCLogUtils._CECClassLogInfo);
                }
            }
        }
        boolean bl2 = this.updateInSysProfiles(vector, this.sysProfObjPath);
        if (bl || bl2) {
            System.out.println("+++++++++ system profile has been changed");
        }
    }

    private boolean updateInSysProfiles(Vector vector, CIMObjectPath cIMObjectPath) throws CIMException {
        Object object;
        CIMObjectPath cIMObjectPath2;
        CIMObjectPath cIMObjectPath3;
        CIMObjectPath cIMObjectPath4;
        Object object2;
        Object object3;
        String string;
        Enumeration<Object> enumeration;
        Object object4;
        String string2;
        boolean bl = false;
        System.out.println("+++++++++ updateInSysProfiles");
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(2);
        Vector vector2 = (Vector)cIMProperty.getValue().getValue();
        if (vector2 == null) {
            CIMObjectPath cIMObjectPath5 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
            Enumeration enumeration2 = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath5, cIMObjectPath, null).elements();
            while (enumeration2.hasMoreElements()) {
                CIMObjectPath cIMObjectPath6 = (CIMObjectPath)enumeration2.nextElement();
                CIMInstance cIMInstance = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath6, new CIMClass("IBMHSC_InSysProfile"), false);
                System.out.println("+++++++++ delete association: " + cIMObjectPath6);
                CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath6);
            }
            bl = true;
            System.out.println("++++++++ nvram system profile list empty");
            return bl;
        }
        CIMProperty cIMProperty2 = (CIMProperty)vector.elementAt(3);
        Vector vector3 = (Vector)cIMProperty2.getValue().getValue();
        Hashtable<String, UnsignedInt8> hashtable = new Hashtable<String, UnsignedInt8>();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        int n = 0;
        while (n < vector2.size()) {
            string2 = (String)vector2.elementAt(n);
            object4 = (UnsignedInt8)vector3.elementAt(n);
            hashtable.put(string2, (UnsignedInt8)object4);
            hashtable2.put(string2, new Integer(n));
            ++n;
        }
        string2 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
        object4 = CimomWrapper.associators(this.cimHandle, (CIMObjectPath)string2, cIMObjectPath, null, "Context", "Setting", true, true, null);
        CIMInstance cIMInstance = null;
        if (object4 != null && !((Vector)object4).isEmpty()) {
            enumeration = ((Vector)object4).elements();
            block2: while (enumeration.hasMoreElements()) {
                cIMInstance = (CIMInstance)enumeration.nextElement();
                string = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                string.setNameSpace("root/ibmhscV3_2");
                object3 = (String)cIMInstance.getProperty("SettingID").getValue().getValue();
                object2 = (UnsignedInt8)hashtable.get(object3);
                cIMObjectPath4 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
                cIMObjectPath3 = CimomWrapper.referenceNames(this.cimHandle, cIMObjectPath4, cIMObjectPath, null).elements();
                if (object2 == null) {
                    while (cIMObjectPath3.hasMoreElements()) {
                        cIMObjectPath2 = (CIMObjectPath)cIMObjectPath3.nextElement();
                        System.out.println("+++++++++ check association: " + cIMObjectPath2);
                        object = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath2, new CIMClass("IBMHSC_InSysProfile"), false);
                        cIMObjectPath4 = (CIMObjectPath)object.getProperty("Setting").getValue().getValue();
                        if (!cIMObjectPath4.equals((Object)string)) continue;
                        System.out.println("+++++++++ delete association: " + cIMObjectPath2);
                        CimomWrapper.deleteInstance(this.cimHandle, cIMObjectPath2);
                        bl = true;
                        continue block2;
                    }
                    continue;
                }
                System.out.println("++++++++ defined lpar profile in system profile: " + (String)object3);
                while (cIMObjectPath3.hasMoreElements()) {
                    cIMObjectPath2 = (CIMObjectPath)cIMObjectPath3.nextElement();
                    object = CimomWrapper.getInstance(this.cimHandle, cIMObjectPath2, new CIMClass("IBMHSC_InSysProfile"), false);
                    cIMObjectPath4 = (CIMObjectPath)object.getProperty("Setting").getValue().getValue();
                    if (!cIMObjectPath4.equals((Object)string)) continue;
                    System.out.println("+++++++++ check association: " + cIMObjectPath2);
                    Integer n2 = (Integer)hashtable2.get(object3);
                    boolean bl2 = false;
                    if (CimomWrapper.setProperty((CIMInstance)object, "ActivateOrder", new UnsignedInt8(n2.shortValue()))) {
                        System.out.println("+++++++++ ActivateOrder updated: " + n2);
                        bl2 = true;
                    }
                    if (!bl2) break;
                    CimomWrapper.setInstance(this.cimHandle, cIMObjectPath2, (CIMInstance)object);
                    bl = true;
                    break;
                }
                hashtable.remove(object3);
            }
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            System.out.println("++++++++ creating new InSys instance");
            string = (String)enumeration.nextElement();
            object3 = (UnsignedInt8)hashtable.get(string);
            System.out.println("++++++++ system profile has a new lpar profile: " + string);
            object2 = null;
            object2 = object3.shortValue() > 9 ? "0" + object3 + "*" + this.cecName : "00" + object3 + "*" + this.cecName;
            cIMObjectPath4 = new CIMObjectPath("IBMHSC_LparProfile", "root/ibmhscV3_2");
            cIMObjectPath4.addKey("SettingID", new CIMValue((Object)string));
            cIMObjectPath4.addKey("PartitionName", new CIMValue(object2));
            cIMObjectPath4.addKey("PartitionCreationClassName", new CIMValue((Object)"IBMHSC_Partition"));
            cIMObjectPath4.setNameSpace("root/ibmhscV3_2");
            cIMObjectPath3 = new CIMObjectPath("IBMHSC_InSysProfile", "root/ibmhscV3_2");
            cIMObjectPath2 = this.cimHandle.getClass(cIMObjectPath3, false).newInstance();
            cIMObjectPath2.setProperty("Context", new CIMValue((Object)cIMObjectPath));
            cIMObjectPath2.setProperty("Setting", new CIMValue((Object)cIMObjectPath4));
            object = (Integer)hashtable2.get(string);
            cIMObjectPath2.setProperty("ActivateOrder", new CIMValue((Object)new UnsignedInt8(((Integer)object).shortValue())));
            cIMObjectPath3 = new CIMObjectPath(cIMObjectPath2.getClassName(), cIMObjectPath2.getKeyValuePairs());
            cIMObjectPath3.setNameSpace("root/ibmhscV3_2");
            CimomWrapper.createInstance(this.cimHandle, cIMObjectPath3, (CIMInstance)cIMObjectPath2);
            bl = true;
        }
        if (bl) {
            System.out.println("++++++++ InSys list has been changed");
        }
        return bl;
    }
}

